#include <bits/stdc++.h>

using namespace std;

typedef long long ll;
typedef long double ld;

const int INF = 1e9;
const ll LINF = 1e18;
const int MOD = 998244353;

#define int long long

struct Mint {
    int x;

    Mint(int _x = 1) : x(_x) {}
    Mint operator+(Mint m) {
        if (x + m.x >= MOD) return Mint(x + m.x - MOD);
        return Mint(x + m.x);
    }
    Mint operator-(Mint m) {
        if (x - m.x < 0) return Mint(x - m.x + MOD);
        return Mint(x - m.x);
    }
    Mint operator*(Mint m) {
        return Mint(x * m.x % MOD);
    }
    Mint operator^(int n) {
        Mint ans(1);
        Mint a(x);
        while (n > 0) {
            if (n % 2)
                ans = ans * a;
            a = a * a;
            n /= 2;
        }
        return ans;
    }
    Mint operator/(Mint m) {
        return Mint(x) * (m^(MOD - 2));
    }
};

void solve() {
    int n, m;
    cin >> n >> m;

    vector <vector <Mint>> dp(n + 1, vector <Mint> (n + 1, Mint(0)));

    dp[1][1] = Mint(m);
    for (int i = 2; i <= n; i++) {
        dp[i][1] = dp[i - 1][1] * Mint(m - 1);
    }

    for (int i = 2; i <= n; i++) {
        for (int j = 2; j < i - 1; j++) {
            dp[i][j] = dp[i - 1][j] * Mint(m) - dp[i - j - 1][min(i - j - 1, j)] * Mint(m - 1);
        }
        dp[i][i - 1] = dp[i - 1][i - 1] * Mint(m) - Mint(m);
        dp[i][i] = dp[i - 1][i - 1] * Mint(m);
    }

    Mint all(1);
    for (int i = 0; i < n; i++) all = all * Mint(m);

    Mint suma(0);
    for (int d = 1; d <= n; d++) {
        Mint cnt = dp[n][d] - dp[n][d - 1];
        suma = suma + cnt * Mint(d);
    }

    Mint res = suma / all;
    cout << res.x << "\n";
}

signed main() {
    ios_base::sync_with_stdio(false);

    int t = 1;
    cin >> t;
    while (t--) {
        solve();
    }
}
